package gov.va.med.mhv.getcare.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.service.HealthCareProviderService;
import gov.va.med.mhv.getcare.web.compare.HealthCareProviderDTOByNameCompare;
import gov.va.med.mhv.getcare.web.compare.HealthCareProviderDTOByTypeCompare;
import gov.va.med.mhv.getcare.web.util.FacesUtil;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@Scope("session")
public class HealthCareProviderController extends AbstractController {
	private static final long serialVersionUID = 656967090214155057L;
	private static Logger log = LogManager.getLogger(HealthCareProviderController.class);

	private static final String SAVE_MESSAGE = "Your last entry has been recorded in the table below.";
	private static final String SAVEADD_MESSAGE = "Your last entry has been recorded, and you may now add another new entry.";
	private static final String DELETE_MESSAGE = "You have successfully deleted an entry from the table below.";

	private DataTable providerTable = new DataTable();

	private List<HealthCareProviderDTO> providers = new ArrayList<HealthCareProviderDTO>();
	private HealthCareProviderDTO selectedProvider = new HealthCareProviderDTO();
	private HealthCareProviderDTO newProvider = new HealthCareProviderDTO();

	@Resource(name = "healthcareproviderServiceProxy")
	private HealthCareProviderService healthCareProviderService;

	public void init(ComponentSystemEvent event) {
		try {
			log.debug("init");

			findUser();
			userprofileId = getUserProfileIdFromSession();
			providerTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("providerForm:provList");

			if (!FacesContext.getCurrentInstance().isPostback()) {
				log.debug("Not postback");
				if (userprofileId != null) {
					loadModel();
				}
				setRowsPerPage(10);
			} else {
				log.debug("postback");
				if (sortColumn != null && sortBy != null) {
					providerTable.setValueExpression("sortBy", sortColumn);
					providerTable.setSortOrder(sortBy);
				}
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}

	private void loadModel() {
		List<HealthCareProviderDTO> dtoList = null;

		try {
			log.debug("loadModel");
			Long userProfileId = getUserProfileIdFromSession();
			dtoList = healthCareProviderService.findProvidersForUser(userProfileId);
			if (dtoList != null) {
				Collections.sort(dtoList, new HealthCareProviderDTOByTypeCompare());
				providers = dtoList;
			} else {
				providers.clear();
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
	}

	public void onSort(SortEvent event) {
		sortColumn = event.getSortColumn().getValueExpression("sortBy");
		sortBy = event.isAscending() ? "ascending" : "descending";
	}

	public int sortByType(Object ob1, Object ob2) {
		HealthCareProviderDTO prov1 = (HealthCareProviderDTO) ob1;
		HealthCareProviderDTO prov2 = (HealthCareProviderDTO) ob2;

		Boolean asc = FacesUtil.getSortColumnAscending("providerForm:provList");

		HealthCareProviderDTOByTypeCompare comparator = new HealthCareProviderDTOByTypeCompare(asc);

		return comparator.compare(prov1, prov2);
	}

	public int sortByName(Object ob1, Object ob2) {
		HealthCareProviderDTO prov1 = (HealthCareProviderDTO) ob1;
		HealthCareProviderDTO prov2 = (HealthCareProviderDTO) ob2;

		HealthCareProviderDTOByNameCompare comparator = new HealthCareProviderDTOByNameCompare();

		return comparator.compare(prov1, prov2);
	}

	public String showDetail(HealthCareProviderDTO provider) {
		selectedProvider = provider;
		return "provider";
	}

	public String editDisplay(HealthCareProviderDTO provider) {
		selectedProvider = provider;
		return "editProviderDisplay";
	}

	public String deleteDisplay(HealthCareProviderDTO provider) {
		selectedProvider = provider;
		setDeleteOrigin("tableView");
		return "deleteProviderDisplay";
	}

	public String deleteRecordDisplay() {
		setDeleteOrigin(null);
		return "deleteProviderDisplay";
	}

	public String addDisplay() {
		newProvider = new HealthCareProviderDTO();
		return "addProviderDisplay";
	}

	public String printerFriendlySummary() {
		providerTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("providerForm:provList");
		return "printProviderSummary";
	}

	public String save() {
		String outcome = null;
		ResponseUtil response = null;
		try {
			response = saveProvider();

			if (response.isSuccess()) {
				loadModel();
				outcome = "providerList";
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, SAVE_MESSAGE, SAVE_MESSAGE));
			} else {
				super.processErrorMessages(response);
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public String saveAndAdd() {
		String outcome = null;
		try {
			log.debug("saveAndAdd");
			ResponseUtil response = saveProvider();
			if (response.isSuccess()) {
				loadModel();
				outcome = "addProviderDisplay";
				newProvider = new HealthCareProviderDTO();
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, SAVEADD_MESSAGE, SAVEADD_MESSAGE));
			} else {
				super.processErrorMessages(response);
			}
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public String backToList() {
		return "providerList";
	}

	public String dashboardAddDisplay() throws MHVException {
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileIdFromSession();
		loadModel();
		newProvider = new HealthCareProviderDTO();
		return "/views/healthcareprovider/addProviderDisplay";
	}

	public String dashboardViewMore() {
		String outcome = null;
		try {
			log.debug("dashboardViewMore");
			findUser();
			setRowsPerPage(10);
			userprofileId = getUserProfileIdFromSession();
			loadModel();
			outcome = "/views/healthcareprovider/providerList";
		} catch (MHVException e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}
		return outcome;
	}

	public String showDahBoardDetail() throws MHVException {
		log.debug("showDahBoardDetail");
		findUser();
		String providerid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("providerid");
		if (providerid != null) {
			Long id = Long.valueOf(providerid);
			selectedProvider = findProviderById(id);
		}
		return "/views/healthcareprovider/provider";
	}

	private HealthCareProviderDTO findProviderById(Long id) {
		HealthCareProviderDTO dto = null;

		try {
			dto = healthCareProviderService.findByPrimaryKey(id);
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return dto;
	}

	public String delete() {
		String outcome = null;
		ResponseUtil response = new ResponseUtil();
		String providerid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("providerid");
		try {
			if (providerid != null) {
				Long id = Long.valueOf(providerid);
				response = healthCareProviderService.delete(id);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Provider", response.getFailureMessage());
					WebServiceClientUtil.showErrorMessage();
				} else {
					loadModel();
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, DELETE_MESSAGE, DELETE_MESSAGE));
					outcome = "providerList";
				}
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

		return outcome;
	}

	public ResponseUtil saveProvider() {
		ResponseUtil response = new ResponseUtil();

		try {
			String providerid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("providerid");
			HealthCareProviderDTO provider = null;

			if (providerid != null) {
				provider = getSelectedProvider();
			} else {
				provider = getNewProvider();
			}
			provider.setUserProfileId(getUserProfileIdFromSession());

			response = healthCareProviderService.saveHealthCareProvider(provider);
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(ResponseUtil.toResponseUtil(e));
		}

		return response;
	}

	private HealthCareProviderDTO prepareProvider(HealthCareProviderDTO provider) throws MHVException {
		provider.setUserProfileId(getUserProfileIdFromSession());
		return provider;
	}

	public List<HealthCareProviderDTO> getProviders() {
		return providers;
	}

	public void setProviders(List<HealthCareProviderDTO> providers) {
		this.providers = providers;
	}

	public DataTable getProviderTable() {
		return providerTable;
	}

	public void setProviderTable(DataTable providerTable) {
		this.providerTable = providerTable;
	}

	public HealthCareProviderDTO getSelectedProvider() {
		return selectedProvider;
	}

	public void setSelectedProvider(HealthCareProviderDTO selectedProvider) {
		this.selectedProvider = selectedProvider;
	}

	public HealthCareProviderDTO getNewProvider() {
		return newProvider;
	}

	public void setNewProvider(HealthCareProviderDTO newProvider) {
		this.newProvider = newProvider;
	}
}
